unit DiakAdat;

interface
type
     TDiak = class
        nev: string[20];
        tankor: integer;
        kreditpont: integer;
        elozo, kovetkezo: TDiak;
        constructor DCreate;
        procedure DFree;
       end;
     TEvf = class
        elso, utolso: TDiak;
        constructor ECreate;
        procedure EFree;
        function KeresNevSzerint(Neve:string):TDiak;
        function MinKreditpont:integer;
        function MaxKreditpont:integer;
     end;
var
   diak: TDiak;
   evf :TEvf;
   FNev : string;
implementation
   constructor TDiak.DCreate;
   begin
     nev        := '';
     tankor     := 0;
     kreditpont := 0;
     elozo      :=nil;
     kovetkezo  :=nil;
   end;
   procedure TDiak.DFree;
   begin
     Free;
   end;
   constructor TEvf.ECreate;
   begin
     elso   := nil;
     utolso := nil;
   end;
   procedure TEvf.EFree;
   var
       p : TDiak;
   begin
     if Assigned(elso) then
     begin
       p := elso;
       while Assigned(p) do
       begin
         elso := elso.kovetkezo;
         p.DFree;
         p := elso;
       end;
     end;
   end;
   function TEvf.KeresNevSzerint(Neve:string):TDiak;
   var
        p, van:TDiak;
   begin
     p:= elso;
     van := nil;
     while p <> nil do
     begin
       if Neve = p.nev then
             begin
               van := p;
               break;
             end;
     end;
     KeresNevSzerint:=van;
   end;
   function TEvf.MinKreditpont:integer;
   var
     p      : TDiak;
     minimum: integer;
   begin
     p:= elso;
     minimum := elso.kreditpont;
     while p <> nil do
      begin
        if p.kreditpont< minimum
          then
           begin
            minimum:= p.kreditpont;
          end;
        p := p.kovetkezo;
      end;
      MinKreditpont:=minimum;
  end;
  function TEvf.MaxKreditpont:integer;
   var
     p : TDiak;
     maximum: integer;
   begin
     p:= elso;
     maximum := elso.kreditpont;
     while p <> nil do
      begin
        if p.kreditpont> maximum
          then
           begin
            maximum:= p.kreditpont;
           end;
        p:=p.kovetkezo;
     end;
     MaxKreditpont:=maximum;
  end;
end.
